<?php

namespace App\Http\Controllers\Pos;

use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\Pos\PosMDMantencione;
use App\Models\Pos\PosMantencionDetalle;
use App\Http\Controllers\Controller;

class PosMDMantencioneController extends Controller
{
    public function index() {}

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;
        return PosMDMantencione::with(['posMaquinaria','posMaquinaria.parMarca'])->where('pos_mantencion_detalle_id', $filtro)->where('estado',1)->get();
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
                'pos_mantencion_detalle_id' => 'required|integer',
                'pos_mantencione_id'        => 'required|integer',
                'pos_maquinaria_id'         => 'required|integer',
                'detalle'               => 'required|array|min:1',
            ]);

            foreach ($request->detalle as $item) {
                if (!empty($item['id'])) {
                    $mantencion = PosMDMantencione::find($item['id']);
                    if ($mantencion) {
                        $mantencion->update([
                            'pos_mantencion_detalle_id' => $request->pos_mantencion_detalle_id,
                            'pos_mantencione_id'         => $request->pos_mantencione_id,
                            'pos_maquinaria_id'          => $request->pos_maquinaria_id,
                            'detalle'                => $item['detalle'] ?? '',
                            'cantidad'               => $item['cantidad'] ?? 0,
                            'valor'                  => $item['valor'] ?? 0,
                            'total'                  => $item['total'] ?? 0,
                        ]);
                    }
                } else {
                    PosMDMantencione::create([
                        'pos_mantencion_detalle_id' => $request->pos_mantencion_detalle_id,
                        'pos_mantencione_id'         => $request->pos_mantencione_id,
                        'pos_maquinaria_id'          => $request->pos_maquinaria_id,
                        'detalle'                => $item['detalle'] ?? '',
                        'cantidad'               => $item['cantidad'] ?? 0,
                        'valor'                  => $item['valor'] ?? 0,
                        'total'                  => $item['total'] ?? 0,
                    ]);
                }
            }

            $total_suma = PosMDMantencione::where('pos_mantencion_detalle_id', $request->pos_mantencion_detalle_id)
                ->sum('total');

            PosMantencionDetalle::where('id', $request->pos_mantencion_detalle_id)
                ->update(['valor' => $total_suma]);

            return response()->json(['message' => 'Mantención procesada correctamente','status' => true], 201);
        } catch (\Exception $e) {
            Log::error('❌ Error en PosMDMantencioneController@store', ['error' => $e->getMessage(),'trace' => $e->getTraceAsString(),'request' => $request->all()]);
            return response()->json(['message' => 'Error al guardar la mantención','error' => $e->getMessage(),'status' => false], 500);
        }
    }

    public function show(PosMDMantencione $mDMantencione) {}
    public function update(Request $request, PosMDMantencione $mDMantencione) {}
    public function destroy(PosMDMantencione $mDMantencione) {}
}
