<?php

namespace App\Http\Controllers\Pos;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use App\Models\Pos\PosMDespacho;
use App\Models\Pos\PosMaquinaria;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Pos\PosMantencionDetalle;

class PosMDespachoController extends Controller
{
    public function index()
    {
        return PosMDespacho::with([
            'posCliente',
            'posMantenciones.posMDMantenciones.posMaquinaria.parMarca',
            'posMantenciones.posMDMantenciones'
        ])
            ->where('estado', 1)
            ->orderBy('fecha', 'desc')
            ->get();
    }

    public function store(Request $request)
    {
        $arriendo = new PosMDespacho();
        $arriendo->pos_cliente_id = $request->pos_cliente_id;
        $arriendo->par_empresa_id = $request->par_empresa_id;
        $arriendo->retira = $request->retira;
        $arriendo->fecha = Carbon::parse($request->fecha)->format('Y-m-d');
        $arriendo->save();

        $total_arriendo = 0;

        if (!empty($request->detalle)) {
            foreach ($request->detalle as $m) {
                $detalle = PosMantencionDetalle::where('id', $m['id'])->first();
                if ($detalle) {
                    $f_entrada = Carbon::parse($detalle->f_entrada);
                    $f_salida = Carbon::parse($arriendo->fecha);
                    $t_dias = $f_entrada->diffInDays($f_salida) + 1;
                    $t_arriendo = $detalle->valor;
                    $total_arriendo += $t_arriendo;

                    if ($arriendo->id) {
                        $detalle->update([
                            'f_salida' => $f_salida->format('Y-m-d'),
                            'pos_m_despacho_id' => $arriendo->id,
                            'estado' => 0,
                        ]);
                    } else {
                        return response()->json(['message' => 'El ID del arriendo no es válido.', 'status' => false], 400);
                    }
                }
                $estatus = ($m['propio'] == 1) ? 1 : 4;
                PosMaquinaria::where('id', $m['pos_maquinaria_id'])->update(['pos_estatu_id' => $estatus]);
            }
        }

        $arriendo->total = $total_arriendo;
        $arriendo->save();

        return response()->json(['message' => 'Arriendo procesado correctamente','id' => $arriendo->id,'status' => true,'total' => $total_arriendo], 201);
    }

    public function show(PosMDespacho $mDespacho) {}
    public function update(Request $request, PosMDespacho $mDespacho) {}
    public function destroy(PosMDespacho $mDespacho) {}

    public function pdfdespacho(PosMDespacho $mDespacho)
    {
        $mDespacho->load('posMantencionDetalles.posMDMantenciones');
        $pdf = PDF::loadView('reports.mdespacho', compact('mDespacho'));
        return $pdf->stream();
    }

    public function imprimirTicket($id)
    {
        $posMDespacho = PosMDespacho::with('posCliente', 'posMantencionDetalles.posMaquinaria')->findOrFail($id);

        $pdf = Pdf::loadView('reports/mdespacho', compact('posMDespacho'))
            ->setPaper([0, 0, 226.77, 1000]);

        return response($pdf->output(), 200)
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="ticket.pdf"');
    }
}
