<?php

namespace App\Http\Controllers\Pos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pos\PosMDMantencione;
use App\Models\Pos\PosMantencionDetalle;

class PosMantencionDetalleController extends Controller
{
    public function index()
    {
        return PosMantencionDetalle::with(['posMaquinaria','posMaquinaria.parMarca','posMaquinaria.posCliente'])
        ->where('estado', 1)
        ->orderBy('f_entrada', 'asc') // Orden ascendente por fecha
        ->get();
    }

    public function Filtro2(Request $request)
    {
        $filtro = $request->filtro;
        return PosMantencionDetalle::with(['posMaquinaria', 'posMaquinaria.parMarca', 'posMantencione'])
        ->whereHas('posMantencione', function ($query) use ($filtro) {
            $query->where('pos_cliente_id', $filtro);
        })
        ->where('estado', 1)
        ->get();
    }

    public function FiltroMaquinaria(Request $request)
    {
        $filtro = $request->filtro;
        if (!$filtro) {
            return response()->json(['error' => 'El filtro de maquinaria es obligatorio'], 400);
        }
        return PosMantencionDetalle::with([
            'Maquinaria',
            'maquinaria.marca',
            'mdMantenciones' => function($query) {
                $query->where('estado', 1);
            },
            'mdMantenciones.Maquinaria',
            'mdMantenciones.maquinaria.marca'
        ])
        ->where('maquinaria_id', $filtro)
        ->orderBy('f_entrada', 'asc')
        ->get();
    }

    public function store(Request $request) {}
    public function show(PosMantencionDetalle $mantencionDetalle) {}
    public function update(Request $request, PosMantencionDetalle $mantencionDetalle) {}
    public function destroy(PosMantencionDetalle $mantencionDetalle) {}
}
