<?php

namespace App\Http\Controllers\Pos;

use App\Http\Controllers\Controller;
use App\Models\Pos\PosMantencione;
use App\Models\Pos\PosMaquinaria;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Pos\PosMantencionDetalle;
use Illuminate\Http\Request;

class PosMantencioneController extends Controller
{
    public function index()
    {
        return PosMantencione::with(['posCliente', 'posMentencionDetalles.posMaquinaria','posMentencionDetalles.posMaquinaria.parMarca'])
        ->where('estado', 1)
        ->orderBy('fecha', 'desc')
        ->get();
    }

    public function store(Request $request)
    {
         $mantencione = new PosMantencione();
        $mantencione->pos_cliente_id = $request->pos_cliente_id;
        $mantencione->par_empresa_id = $request->par_empresa_id;
        $mantencione->recepciona = $request->recepciona;
        $mantencione->fecha = $request->fecha;
        $mantencione->save(); // Guardar el registro para generar el ID
    
        // Verificar si existen detalles en la solicitud
        if (isset($request->detalle) && !empty($request->detalle)) {
            foreach ($request->detalle as $m) {
                // Crear un nuevo registro de detalle
                $detalle = new PosMantencionDetalle();
                $detalle->pos_maquinaria_id = $m['pos_maquinaria_id'];
                $detalle->valor = 0;
                $detalle->detalle = $m['detalle'];
                $detalle->pos_mantencione_id = $mantencione->id; // Usar el ID recién generado
                $detalle->f_entrada = $mantencione->fecha;
                $detalle->save(); // Guardar el detalle
    
                // Actualizar el estatus_id de la maquinaria
                PosMaquinaria::where('id', $m['pos_maquinaria_id'])->update(['pos_estatu_id' => 3]);
            }
        }
    
        return response()->json([
            'message' => 'Arriendo registrado con éxito',
            'id' => $mantencione->id,
        ], 201);
    }

    public function show(PosMantencione $mantencione) {}
    public function update(Request $request, PosMantencione $mantencione) {}
    public function destroy(PosMantencione $mantencione) {}

    public function pdfingreso(PosMantencione $mantencione)
    {
        $mantencione->load('pos_mantencione_detalles.maquinaria');
        $pdf = PDF::loadView('reports.mingreso', compact('mantencione'));
        return $pdf->stream();
    }

    public function imprimirTicket($id)
    {
        $posMantencione = PosMantencione::with('posCliente', 'posMantencionDetalles.posMaquinaria')->findOrFail($id);

        $pdf = Pdf::loadView('reports/mingreso', compact('posMantencione'))
            ->setPaper([0, 0, 226.77, 1000]);

        return response($pdf->output(), 200)
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="ticket.pdf"');
    }
}
