<?php

namespace App\Http\Controllers\Pos;
use Illuminate\Routing\Controller;

use App\Models\Pos\PosMaquinaria;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PosMaquinariaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return PosMaquinaria::with(['parMarca', 'parTMaquinaria', 'posCategoria', 'posCliente', 'posEstatu'])
    ->where('estado', 1)
    ->orderBy('nombre', 'asc') // Orden ascendente por nombre
    ->get();
    }

    public function Filtro(Request $request)
    {
        $filtro = explode(',', $request->filtro); // Convierte "1,4" en [1,4]
        return PosMaquinaria::with(['parMarca', 'parTMaquinaria', 'posCategoria', 'posCliente', 'posEstatu'])->whereIn('pos_estatu_id', $filtro)->where('estado',1)->get();
    }
    
    public function Filtro1(Request $request)
    {
        $filtro = explode(',', $request->filtro);
        $filtro1 = explode(',', $request->filtro1); // Convierte "1,4" en [1,4]
        return PosMaquinaria::with(['parMarca', 'parTMaquinaria', 'posCategoria', 'posCliente', 'posEstatu'])->whereIn('pos_estatu_id', $filtro)->whereIn('pos_cliente_id', $filtro1)->where('estado',1)->get();
    }
    public function Filtro2(Request $request)
    {
        $filtro = $request->filtro;
        $cliente = $request->cliente;
        return PosMaquinaria::with(['parMarca', 'parTMaquinaria', 'posCategoria', 'posCliente', 'posEstatu'])->where('pos_estatu_id', $filtro)->where('pos_cliente_id', $cliente)->where('estado',1)->get();
    }

    public function Filtro3(Request $request)
    {
        $filtro = explode(',', $request->filtro); // Convierte "1,4" en [1,4]
        $maquinarias = PosMaquinaria::with(['parMarca', 'parTMaquinaria', 'posCategoria', 'posCliente', 'posEstatu'])
            ->whereIn('par_empresa_id', $filtro)
            ->where('propio', 1)
            ->where('estado', 1)
            ->select('pos_maquinarias.*')
            ->selectSub(function ($query) {
                $query->select('pos_clientes.nombre')
                    ->from('pos_arriendo_detalles')
                    ->join('pos_arriendos', 'pos_arriendo_detalles.pos_arriendo_id', '=', 'pos_arriendos.id')
                    ->join('pos_clientes', 'pos_arriendos.pos_cliente_id', '=', 'pos_clientes.id')
                    ->whereColumn('pos_arriendo_detalles.pos_maquinaria_id', 'pos_maquinarias.id')
                    ->where('pos_arriendo_detalles.estado', 1)
                    ->where('pos_arriendos.estado', 1)
                    ->limit(1);
            }, 'cliente_mantencion')
            ->orderBy('nombre', 'asc')
            ->get();

        return response()->json($maquinarias);
    }


            public function filtroAvanzado(Request $request)
            {
                // ✅ Obtener filtros del request - manejar tanto arrays como valores únicos
                $empresasIds = $request->input('empresa');
                $marcas = $request->input('marca', []);
                $categorias = $request->input('categoria', []);
                $anios = $request->input('anio', []); // ✅ Filtro por años
                $meses = $request->input('mes', []); // ✅ Filtro por meses
            
                // ✅ Convertir empresa a array si viene como valor único
                if (!is_array($empresasIds)) {
                    $empresasIds = $empresasIds ? [$empresasIds] : [];
                }
            // Query base - solo maquinarias activas
            $query = PosMaquinaria::with(['parMarca', 'parTMaquinaria', 'posCategoria', 'posCliente', 'posEstatu'])
                ->where('estado', 1);

            // ✅ Filtro por empresa (par_empresa_id -> rut -> pos_cliente_id) 
            if (!empty($empresasIds) && is_array($empresasIds)) {
                $empresasIdsLimpio = array_filter(array_map('intval', $empresasIds));
                    if (!empty($empresasIdsLimpio)) {
                        // 1. Obtener RUTs de las empresas
                        $empresasRuts = \App\Models\Parametros\ParEmpresa::whereIn('id', $empresasIdsLimpio)
                            ->pluck('rut')
                            ->toArray();
                        
                        // 2. Buscar ven_cliente_ids que coincidan con esos RUTs
                        $venClienteIds = \App\Models\Pos\PosCliente::whereIn('rut', $empresasRuts)
                            ->pluck('id')
                            ->toArray();
                        
                        // 3. Filtrar maquinarias por esos ven_cliente_ids
                        if (!empty($venClienteIds)) {
                            $query->whereIn('pos_cliente_id', $venClienteIds);
                        } else {
                            // Si no se encuentran clientes, no mostrar nada
                            $query->where('id', 0);
                        }
                    }
                }
            
                // ✅ Filtro por marca (par_marca_id) - si se envía y no está vacío
                if (!empty($marcas) && is_array($marcas)) {
                    $marcasIds = array_filter(array_map('intval', $marcas));
                    if (!empty($marcasIds)) {
                        $query->whereIn('par_marca_id', $marcasIds);
                    }
                }
            
                // ✅ Filtro por categoría (pos_categoria_id) - si se envía y no está vacío
                if (!empty($categorias) && is_array($categorias)) {
                    $categoriasIds = array_filter(array_map('intval', $categorias));
                    if (!empty($categoriasIds)) {
                        $query->whereIn('pos_categoria_id', $categoriasIds);
                    }
                }
            
                // ✅ Filtro por año - obtener números de año de la tabla anos y buscar en ambas tablas usando f_salida
                if (!empty($anios) && is_array($anios)) {
                    $aniosIds = array_filter(array_map('intval', $anios));
                    if (!empty($aniosIds)) {
                        // 1. Obtener los números de año (columna nro) de la tabla anos
                        $aniosNumeros = \App\Models\Parametros\ParAnio::whereIn('id', $aniosIds)
                            ->pluck('nro')
                            ->toArray();
                        
                        if (!empty($aniosNumeros)) {
                            // 2. Buscar maquinaria_ids en pos_mantencion_detalles que tengan mantenciones en esos años
                            $maquinariaIdsConMantenciones = \App\Models\Pos\PosMantencionDetalle::whereIn(
                                DB::raw('YEAR(f_salida)'), 
                                $aniosNumeros
                            )
                            ->distinct()
                            ->pluck('pos_maquinaria_id')
                            ->toArray();
        
                            // 3. Buscar maquinaria_ids en pos_arriendo_detalles que tengan arriendos en esos años (usando f_salida)
                            $maquinariaIdsConArriendos = \App\Models\Pos\PosArriendoDetalle::whereIn(
                                DB::raw('YEAR(f_salida)'), 
                                $aniosNumeros
                            )
                            ->distinct()
                            ->pluck('pos_maquinaria_id')
                            ->toArray();
        
                            // 4. Combinar ambos arrays de IDs y eliminar duplicados
                            $maquinariaIdsTotal = array_unique(array_merge($maquinariaIdsConMantenciones, $maquinariaIdsConArriendos));
                            
                            // 5. Filtrar solo las maquinarias que tuvieron mantenciones o arriendos en esos años
                            if (!empty($maquinariaIdsTotal)) {
                                $query->whereIn('id', $maquinariaIdsTotal);
                            } else {
                                // Si no hay maquinarias con mantenciones o arriendos en esos años, no mostrar nada
                                $query->where('id', 0);
                            }
                        } else {
                            // Si no se encuentran años válidos, no mostrar nada
                            $query->where('id', 0);
                        }
                    }
                }
        
                // ✅ Filtro por mes - obtener números de mes de la tabla meses y buscar en ambas tablas usando f_salida
                if (!empty($meses) && is_array($meses)) {
                    $mesesIds = array_filter(array_map('intval', $meses));
                    if (!empty($mesesIds)) {
                        // 1. Obtener los números de mes (columna nro) de la tabla meses
                        $mesesNumeros = \App\Models\Parametros\ParMese::whereIn('id', $mesesIds)
                            ->pluck('nro')
                            ->toArray();
                        
                        if (!empty($mesesNumeros)) {
                            // 2. Buscar maquinaria_ids en pos_mantencion_detalles que tengan mantenciones en esos meses
                            $maquinariaIdsConMantencionesMes = \App\Models\pos\PosMantencionDetalle::whereIn(
                                DB::raw('MONTH(f_salida)'), 
                                $mesesNumeros
                            )
                            ->distinct()
                            ->pluck('pos_maquinaria_id')
                            ->toArray();
        
                            // 3. Buscar maquinaria_ids en pos_arriendo_detalles que tengan arriendos en esos meses (usando f_salida)
                            $maquinariaIdsConArriendosMes = \App\Models\Pos\PosArriendoDetalle::whereIn(
                                DB::raw('MONTH(f_salida)'), 
                                $mesesNumeros
                            )
                            ->distinct()
                            ->pluck('pos_maquinaria_id')
                            ->toArray();
        
                            // 4. Combinar ambos arrays de IDs y eliminar duplicados
                            $maquinariaIdsTotalMes = array_unique(array_merge($maquinariaIdsConMantencionesMes, $maquinariaIdsConArriendosMes));
                            
                            // 5. Filtrar solo las maquinarias que tuvieron mantenciones o arriendos en esos meses
                            if (!empty($maquinariaIdsTotalMes)) {
                                $query->whereIn('id', $maquinariaIdsTotalMes);
                            } else {
                                // Si no hay maquinarias con mantenciones o arriendos en esos meses, no mostrar nada
                                $query->where('id', 0);
                            }
                        } else {
                            // Si no se encuentran meses válidos, no mostrar nada
                            $query->where('id', 0);
                        }
                    }
                }
            
                // ✅ Obtener maquinarias con información individual de gastos y ganancias
                $maquinarias = $query->select('pos_maquinarias.*')
                    ->selectSub(function ($query) {
                        $query->selectRaw('COALESCE(SUM(valor), 0)')
                            ->from('pos_mantencion_detalles')
                            ->whereColumn('pos_mantencion_detalles.pos_maquinaria_id', 'pos_maquinarias.id')
                            ->where('pos_mantencion_detalles.estado', 1);
                    }, 'total_gasto_mantencion')
                    ->selectSub(function ($query) {
                        $query->selectRaw('COALESCE(SUM(v_total), 0)')
                            ->from('pos_arriendo_detalles')
                            ->whereColumn('pos_arriendo_detalles.pos_maquinaria_id', 'pos_maquinarias.id');
                    }, 'total_ganancia_arriendo')
                    ->addSelect(DB::raw('COALESCE(p_compra, 0) as precio_compra'))
                    ->orderBy('nombre', 'asc')
                    ->get();
        
                return response()->json($maquinarias);
            }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $posMaquinaria = new PosMaquinaria();
        $posMaquinaria->fecha = $request->fecha;
        $posMaquinaria->par_c_costo_id = $request->par_c_costo_id;
        $posMaquinaria->nombre = $request->nombre;
        $posMaquinaria->par_marca_id = $request->par_marca_id;
        $posMaquinaria->pos_categoria_id = $request->pos_categoria_id;
        $posMaquinaria->modelo = $request->modelo;
        $posMaquinaria->par_t_maquinaria_id = $request->par_t_maquinaria_id;
        $posMaquinaria->pos_cliente_id = $request->pos_cliente_id;
        $posMaquinaria->garantia = $request->garantia ?? 0; // Si garantía es null, se asigna 0
        $posMaquinaria->f_compra = $request->f_compra;
        $posMaquinaria->d_garantia = $request->d_garantia ?? 0;
        $posMaquinaria->p_compra = $request->propio == 1 ? $request->p_compra : 0;
        $posMaquinaria->par_empresa_id = $request->par_empresa_id;
        $posMaquinaria->par_sucursal_id = $request->par_sucursal_id;
        $posMaquinaria->v_arriendo = $request->propio == 1 ? $request->v_arriendo : 0;
        $posMaquinaria->propio = $request->propio == 1 ? $request->propio : 0;
        $posMaquinaria->pos_estatu_id = $request->propio == 1 ? 1 : 4;
        $posMaquinaria->save(); // Se guarda la posMaquinaria para generar el ID
    
        // Generar el código combinando el ID y par_empresa_id
        $par_empresa_id = $request->par_empresa_id;
        $posMaquinaria->codigo = "{$request->pos_cliente_id}-{$posMaquinaria->id}";
        $posMaquinaria->save(); // Guardar nuevamente el código generado
    
        return $posMaquinaria;
    }
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PosMaquinaria  $posMaquinaria
     * @return \Illuminate\Http\Response
     */
    public function show(PosMaquinaria $posMaquinaria)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PosMaquinaria  $posMaquinaria
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PosMaquinaria $posMaquinaria)
    {
        $posMaquinaria->fecha = $request->fecha;
        $posMaquinaria->par_c_costo_id = $request->par_c_costo_id;
        $posMaquinaria->nombre = $request->nombre;
        $posMaquinaria->modelo = $request->modelo;
        $posMaquinaria->par_marca_id = $request->par_marca_id;
        $posMaquinaria->pos_categoria_id = $request->pos_categoria_id;
        $posMaquinaria->par_t_maquinaria_id = $request->par_t_maquinaria_id;
        $posMaquinaria->pos_estatu_id = $request->pos_estatu_id;
        $posMaquinaria->pos_cliente_id = $request->pos_cliente_id;
        $posMaquinaria->propio = $request->propio;
        $posMaquinaria->p_compra = $request->p_compra;
        $posMaquinaria->v_arriendo = $request->v_arriendo;
        $posMaquinaria->save();
        return $posMaquinaria;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PosMaquinaria  $posMaquinaria
     * @return \Illuminate\Http\Response
     */
    public function destroy(PosMaquinaria $posMaquinaria)
    {
        $posMaquinaria->estado = 0;
        $posMaquinaria->save();
    }
}
