<?php
namespace App\Http\Controllers\Pos;
use App\Http\Controllers\Controller;

use App\Models\Pos\PosMetodo;
use Illuminate\Http\Request;

class PosMetodoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return PosMetodo::where('estado',1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $posMetodo = new PosMetodo();
        $posMetodo->nombre = $request->nombre;
        $posMetodo->save();
        return $posMetodo;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PosMetodo  $posMetodo
     * @return \Illuminate\Http\Response
     */
    public function show(PosMetodo $posMetodo)
    {
        return $posMetodo;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PosMetodo  $posMetodo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PosMetodo $posMetodo)
    {
        $posMetodo->nombre = $request->nombre;
        $posMetodo->save();
        return $posMetodo;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PosMetodo  $posMetodo
     * @return \Illuminate\Http\Response
     */
    public function destroy(PosMetodo $posMetodo)
    {
        $posMetodo->estado = 0;
        $posMetodo->save();
    }
}
