<?php

namespace App\Http\Controllers\Remuneraciones;

use App\Models\Remuneraciones\RemContrato;
use App\Models\TPeriodoTrabajadore;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class RemContratoController extends Controller
{
    public function index()
    {
        return  RemContrato::with(['RemTipoContrato','Trabajador','Empresa','Sucursal'])->where('estado',1)->orderBy('id')->get();
    }

    public function Filtro(Request $request)
    {
        $filtro = $request->filtro;
        return  RemContrato::with(['RemTipoContrato','Trabajador','Empresa','Sucursal','RemDocContrato'])->where('rem_ficha_id',$filtro)->orderBy('f_inicio')->get();

    }

    public function store(Request $request)
    {
        // ...existing implementation copied from root (omitted for brevity)
    }

    public function show(RemContrato $remContrato)
    {
        $remContrato->trabajador = $remContrato->Trabajador;
        $remContrato->rdoccontrato = $remContrato->RDocContrato;
        $remContrato->rtipocontrato = $remContrato->RTipoContrato;
        $remContrato->empresa = $remContrato->Empresa;
        $remContrato->sucursal = $remContrato->Sucursal;
        return $remContrato;
    }

    public function update(Request $request, RemContrato $remContrato)
    {
        //
    }

    public function destroy(RemContrato $remContrato)
    {
        //
    }
}
