<?php

namespace App\Http\Controllers\Remuneraciones;

use App\Models\Remuneraciones\RemDocContrato;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class RemDocContratoController extends Controller
{
    public function index()
    {
        return RemDocContrato::where('estado',1)->orderBy('nombre')->get();
    }

    public function store(Request $request)
    {
        return RemDocContrato::create($request->all());
    }

    public function show(RemDocContrato $remDocContrato)
    {
        return $remDocContrato;
    }

    public function update(Request $request, RemDocContrato $remDocContrato)
    {
        $remDocContrato->update($request->all());
        return $remDocContrato;
    }

    public function destroy(RemDocContrato $remDocContrato)
    {
        $remDocContrato->estado = 0;
        $remDocContrato->save();
        return response()->json(['ok' => true]);
    }
}
