<?php

namespace App\Http\Controllers\Remuneraciones;


use Illuminate\Support\Facades\DB;
use App\Models\Remuneraciones\RemFicha;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class RemFichaController extends Controller
{
    public function index()
    {
        return RemFicha::with(['parEmpresa', 'parPais', 'parRegion', 'parComuna', 'parCiudad', 'parSucursal'])->where('estado', 1)->orderBy('nombre')->get();
      
    }

    public function filtro(Request $request)
    {
        $filtro = $request->filtro;
        $model = RemFicha::with(['pais', 'ciudad'])->where('id', $filtro)->where('estado', 1)->orderBy('nombre')->get();
        $list = [];
        foreach ($model as $m) {
            $list[] = $this->imagen($m);
        }
        return $list;
    }
    public function empresa(Request $request)
    {
        $filtro = $request->filtro;
        $sucursal = $request->sucursal;

        $model = RemFicha::with(['parPais', 'parRegion', 'parComuna', 'parCiudad', 'parSucursal'])
            ->where('par_empresa_id', $filtro)
            ->where('par_sucursal_id', $sucursal)
            ->where('estado', 1)
            ->orderBy('nombre')
            ->get();

        $list = [];
        foreach ($model as $m) {
         
            $ficha['nombre_completo'] = trim("{$m->nombre} {$m->a_paterno} {$m->a_materno}");
            $ficha['seleccionado'] = false;
            $list[] = $ficha;
        }

        return $list;
    }

    public function empresa1(Request $request)
    {
        $filtro = $request->filtro;

        $model = RemFicha::with(['parPais', 'parRegion', 'parComuna', 'parCiudad', 'parSucursal'])
            ->where('par_empresa_id', $filtro)
            ->where('estado', 1)
            ->orderBy('nombre')
            ->get();

        $list = [];
        foreach ($model as $m) {
          
            $ficha['nombre'] = trim("{$m->nombre} {$m->a_paterno} {$m->a_materno}");
            $ficha['seleccionado'] = false;
            $list[] = $ficha;
        }

        return $list;
    }

    public function sucursal(Request $request)
    {
        $filtro = $request->filtro;
        $sucursal = $request->sucursal;
        $model = RemFicha::with(['parPais', 'parRegion', 'parComuna', 'parCiudad', 'parSucursal'])->where('par_sucursal_id', $sucursal)->where('estado', 1)->orderBy('nombre')->get();
        $list = [];
        foreach ($model as $m) {
            $list[] = $this->imagen($m);
        }
        return $list;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $remFicha = new RemFicha();
        $remFicha->nombre = $request->nombre;
        $remFicha->a_paterno = $request->a_paterno;
        $remFicha->a_materno = $request->a_materno;
        $remFicha->rut = $request->rut;
        $remFicha->f_nacimiento = $request->f_nacimiento;
        $remFicha->rem_nacionalidade_id = $request->rem_nacionalidade_id;
        $remFicha->rem_sexo_id = $request->rem_sexo_id;
        $remFicha->rem_estado_civile_id = $request->rem_estado_civile_id;
        $remFicha->pais_id = $request->pais_id;
        $remFicha->par_empresa_id = $request->par_empresa_id;
        $remFicha->par_sucursal_id = $request->par_sucursal_id;
        $remFicha->region_id = $request->region_id;
        $remFicha->comuna_id = $request->comuna_id;
        $remFicha->ciudad_id = $request->ciudad_id;
        $remFicha->direccion = $request->direccion;
        $remFicha->e_personal = $request->e_personal;
        $remFicha->e_institucional = $request->e_institucional;
        $remFicha->t_personal = $request->t_personal;
        $remFicha->t_emergencia = $request->t_emergencia;

        $remFicha->save();

        // Procesar imagen si existe
        if ($request->hasFile('imagen')) {
            $file = $request->file('imagen');
            $extension = $file->getClientOriginalExtension();
            $fileName = $remFicha->id . '.' . $extension;
            $path = $file->storeAs('imagenes', $fileName, 'public');
            $remFicha->url = "/storage/" . $path;
        } else {
            $remFicha->url = "/storage/imagenes/users.png";
        }

        $remFicha->save();
        // Insertar en rem_historial_afp_salud
        $periodo = DB::table('par_periodos')->where('id', $request->par_periodo_id)->first();
        if ($periodo) {
            $anio = DB::table('par_anios')->where('id', $periodo->par_anio_id)->value('nro');
            $mes = DB::table('par_meses')->where('id', $periodo->par_mese_id)->value('nro');
            $fecha_inicio = $anio . '-' . str_pad($mes, 2, '0', STR_PAD_LEFT) . '-01';
        } else {
            $fecha_inicio = now()->format('Y-m-01');
        }

        DB::table('rem_historial_afp_salud')->insert([
            'rem_ficha_id'      => $remFicha->id,
            'rem_afp_id'        => $request->rem_afp_id,
            'rem_salud_id'      => $request->rem_salud_id,
            'pensionado'      => $request->pensionado,
            'uf'                => $request->uf,
            'pesos'             => $request->pesos,
            'porcentaje'        => $request->porcentaje,
            'fecha_inicio'      => $fecha_inicio,
            'created_at'        => now(),
            'updated_at'        => now(),
        ]);



        return $remFicha;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\RemFicha  $remFicha
     * @return \Illuminate\Http\Response
     */
    public function show(RemFicha $remFicha)
    {
        $remFicha->pais = $remFicha->Pais;
        $remFicha->empresa = $remFicha->Empresa;
        $remFicha->sucursal = $remFicha->Sucursal;
        $remFicha->remNacionalidade = $remFicha->RemNacionalidade;
        $remFicha->remSexo = $remFicha->RemSexo;
        $remFicha->remEstadoCivile = $remFicha->RemEstadoCivile;
        $remFicha->region = $remFicha->Region;
        $remFicha->comuna = $remFicha->Comuna;
        $remFicha->ciudad = $remFicha->Ciudad;
        $remFicha->image = $remFicha->Images;
        return $remFicha;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\RemFicha  $remFicha
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, RemFicha $remFicha)
    {
        $remFicha->nombre = $request->nombre;
        $remFicha->a_paterno = $request->a_paterno;
        $remFicha->a_materno = $request->a_materno;
        $remFicha->rut = $request->rut;
        $remFicha->f_nacimiento = $request->f_nacimiento;
        $remFicha->rem_nacionalidade_id = $request->rem_nacionalidade_id;
        $remFicha->rem_sexo_id = $request->rem_sexo_id;
        $remFicha->rem_estado_civile_id = $request->rem_estado_civile_id;
        $remFicha->pais_id = $request->pais_id;
        $remFicha->region_id = $request->region_id;
        $remFicha->comuna_id = $request->comuna_id;
        $remFicha->ciudad_id = $request->ciudad_id;
        $remFicha->direccion = $request->direccion;
        $remFicha->e_personal = $request->e_personal;
        $remFicha->e_institucional = $request->e_institucional;
        $remFicha->t_personal = $request->t_personal;
        $remFicha->t_emergencia = $request->t_emergencia;
        $remFicha->save();
        return $remFicha;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Trabajador  $remFicha
     * @return \Illuminate\Http\Response
     */
    public function destroy(RemFicha $remFicha)
    {
        $remFicha->estado = 0;
        $remFicha->save();
    }
    public function Imagen(RemFicha $remFicha)
    {


        $remFicha->pais = $remFicha->Pais;
        $remFicha->empresa = $remFicha->Empresa;
        $remFicha->region = $remFicha->Region;
        $remFicha->comuna = $remFicha->Comuna;
        $remFicha->ciudad = $remFicha->Ciudad;
        $remFicha->image = $remFicha->FichaImages()->get()->first();
        if ($remFicha->image != null) {
            $remFicha->image->url = $remFicha->image->image->UrlImage();
        }
        return $remFicha;
    }
}
