<?php

namespace App\Http\Controllers\Remuneraciones;

use App\Models\Remuneraciones\RemTipoRemuneracion;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class RemTipoRemuneracionController extends Controller
{
    public function index()
    {
        return RemTipoRemuneracion::where('estado',1)->orderBy('id')->get();
    }

    public function store(Request $request)
    {
        return RemTipoRemuneracion::create($request->all());
    }

    public function show(RemTipoRemuneracion $remTipoRemuneracion)
    {
        return $remTipoRemuneracion;
    }

    public function update(Request $request, RemTipoRemuneracion $remTipoRemuneracion)
    {
        $remTipoRemuneracion->update($request->all());
        return $remTipoRemuneracion;
    }

    public function destroy(RemTipoRemuneracion $remTipoRemuneracion)
    {
        $remTipoRemuneracion->estado = 0;
        $remTipoRemuneracion->save();
        return response()->json(['ok' => true]);
    }
}
