<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\User;

class ServiceTokenController extends Controller
{
    /**
     * Issue a service token for scripts. Requires SERVICE_TOKEN_SECRET in .env.
     */
    public function issue(Request $request)
    {
        $secret = env('SERVICE_TOKEN_SECRET');
        $provided = $request->input('secret');

        if (!$secret || $provided !== $secret) {
            Log::warning('Intento de emitir token de servicio fallido.');
            return response()->json(['error' => 'Secret inválido'], 401);
        }

        // You can configure SERVICE_TOKEN_USER_ID in env to choose which user owns the token
        $userId = env('SERVICE_TOKEN_USER_ID');
        $user = $userId ? User::find($userId) : User::first();
        if (!$user) {
            return response()->json(['error' => 'Usuario de servicio no encontrado'], 500);
        }

        $token = $user->createToken('service-token')->plainTextToken;
        return response()->json(['token' => $token]);
    }
}
