<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SiiLibroController extends Controller
{
    public function descargar(Request $request)
    {
        $request->validate([
            'rut' => 'required',
            'clave' => 'required',
            'periodo' => 'required' // Formato: 2025-04
        ]);

        $rut = $request->rut;
        $clave = $request->clave;
        $periodo = $request->periodo;

        // Ejecutar el script Node (Playwright)
        $output = shell_exec("node scripts/descargar_sii.js $rut $clave $periodo");

        // Validar si el script dejó un archivo en storage
        $nombreArchivo = "libro-compra-$rut-$periodo.xlsx";
        $rutaArchivo = storage_path("app/libros/$nombreArchivo");

        if (!file_exists($rutaArchivo)) {
            return response()->json(['error' => 'No se pudo descargar el libro.'], 500);
        }

        // Devolver URL de descarga
        return response()->json([
            'archivo' => asset("storage/libros/$nombreArchivo")
        ]);
    }
}
