<?php
namespace App\Http\Controllers;

use App\Models\TablaDocCompras;  // Cambiarlo a TablaDocCompras si corresponde
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class TablaDocComprasController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all(); // Recibe todos los datos
    
        // Guardar los datos en la base de datos
        foreach ($data as $row) {
            // Accede a los valores usando las claves exactas
            $tipo_doc = $row["Tipo Doc"] ?? null;
            $tipo_compra = $row["Tipo Compra"] ?? null;
            $rut_proveedor = $row["RUT Proveedor"] ?? null;
            $razon_social = $row["Razon Social"] ?? null;
            $folio = $row["Folio"] ?? null;
            $fecha_docto = isset($row["Fecha Docto"]) ? Carbon::createFromFormat('d/m/Y', $row["Fecha Docto"])->format('Y-m-d') : null;
            $fecha_recepcion = isset($row["Fecha Recepcion"]) ? Carbon::createFromFormat('d/m/Y H:i:s', $row["Fecha Recepcion"])->format('Y-m-d H:i:s') : null;
            $fecha_acuse = isset($row["Fecha Acuse"]) ? Carbon::createFromFormat('d/m/Y H:i:s', $row["Fecha Acuse"])->format('Y-m-d H:i:s') : null;
            $monto_exento = $row["Monto Exento"] ?? null;
            $monto_neto = $row["Monto Neto"] ?? null;
            $monto_iva_recuperable = $row["Monto IVA Recuperable"] ?? null;
            $monto_iva_no_recuperable = $row["Monto Iva No Recuperable"] ?? null;
            $codigo_iva_no_rec = $row["Codigo IVA No Rec."] ?? null;
            $monto_total = $row["Monto Total"] ?? null;
            $monto_neto_activo_fijo = $row["Monto Neto Activo Fijo"] ?? null;
            $iva_activo_fijo = $row["IVA Activo Fijo"] ?? null;
            $iva_uso_comun = $row["IVA uso Comun"] ?? null;
            $impto_sin_derecho_a_credito = $row["Impto. Sin Derecho a Credito"] ?? null;
            $iva_no_retenido = $row["IVA No Retenido"] ?? null;
            $tabacos_puros = $row["Tabacos Puros"] ?? null;
            $tabacos_cigarrillos = $row["Tabacos Cigarrillos"] ?? null;
            $tabacos_elaborados = $row["Tabacos Elaborados"] ?? null;
            $nce_o_nde_sobre_factura = $row["NCE o NDE sobre Fact. de Compra"] ?? null;
            $codigo_otro_impuesto = $row["Codigo Otro Impuesto"] ?? null;
            $valor_otro_impuesto = $row["Valor Otro Impuesto"] ?? null;
            $tasa_otro_impuesto = $row["Tasa Otro Impuesto"] ?? null;
    
            // Eliminar guion en el RUT del proveedor
            $rut_proveedor_sin_guion = str_replace('-', '', $rut_proveedor);
    
            // Buscar el proveedor en la tabla proveedor usando el RUT
            $proveedor = DB::table('proveedores')->where('rut', $rut_proveedor_sin_guion)->first();
    
            // Si no existe el proveedor, lo agregamos a la tabla proveedores
            if (!$proveedor) {
                $proveedor_id = DB::table('proveedores')->insertGetId([
                    'rut' => $rut_proveedor_sin_guion,
                    'razon_social' => $razon_social,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            } else {
                $proveedor_id = $proveedor->id;
            }
    
            // Verificar si ya existe un registro con el mismo tipo_doc, rut_proveedor y folio
            $exists = DB::table('tabla_doc_compras')
                ->where('tipo_doc', $tipo_doc)
                ->where('rut_proveedor', $rut_proveedor)
                ->where('folio', $folio)
                ->exists();
    
            if (!$exists) {
                // Si no existe, proceder a insertar
                DB::table('tabla_doc_compras')->insert([
                    'tipo_doc' => $tipo_doc,
                    'tipo_compra' => $tipo_compra,
                    'rut_proveedor' => $rut_proveedor,
                    'razon_social' => $razon_social,
                    'folio' => $folio,
                    'fecha_docto' => $fecha_docto,
                    'fecha_recepcion' => $fecha_recepcion,
                    'fecha_acuse' => $fecha_acuse,
                    'monto_exento' => $monto_exento,
                    'monto_neto' => $monto_neto,
                    'monto_iva_recuperable' => $monto_iva_recuperable,
                    'monto_iva_no_recuperable' => $monto_iva_no_recuperable,
                    'codigo_iva_no_rec' => $codigo_iva_no_rec,
                    'monto_total' => $monto_total,
                    'monto_neto_activo_fijo' => $monto_neto_activo_fijo,
                    'iva_activo_fijo' => $iva_activo_fijo,
                    'iva_uso_comun' => $iva_uso_comun,
                    'impto_sin_derecho_a_credito' => $impto_sin_derecho_a_credito,
                    'iva_no_retenido' => $iva_no_retenido,
                    'tabacos_puros' => $tabacos_puros,
                    'tabacos_cigarrillos' => $tabacos_cigarrillos,
                    'tabacos_elaborados' => $tabacos_elaborados,
                    'nce_o_nde_sobre_factura' => $nce_o_nde_sobre_factura,
                    'codigo_otro_impuesto' => $codigo_otro_impuesto,
                    'valor_otro_impuesto' => $valor_otro_impuesto,
                    'tasa_otro_impuesto' => $tasa_otro_impuesto,
                    'proveedore_id' => $proveedor_id,  // Aquí agregas el proveedor_id
                ]);
            }
        }
    
        return response()->json(['message' => 'Datos guardados correctamente'], 200);
    }
    
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TablaDocCompras  $tablaDocCompras
     * @return \Illuminate\Http\Response
     */
    public function show(TablaDocCompras $tablaDocCompras)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TablaDocVentas  $tablaDocVentas
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TablaDocCompras $tablaDocCompras)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TablaDocVentas  $tablaDocVentas
     * @return \Illuminate\Http\Response
     */
    public function destroy(TablaDocCompras $tablaDocCompras)
    {
        //
    }
}
