<?php

namespace App\Http\Controllers;

use App\Models\Pos\PosTraspaso;
use App\Models\TraspasoInventario;
use App\Models\Pos\PosInventario;
use Illuminate\Http\Request;

class TraspasoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $posTraspaso = PosTraspaso::orderBy('fecha', 'desc')->where('estado', 1)->with(['Documento', 'Metodo', 'Bodega'])->get();

        $list = [];
        foreach ($posTraspaso as $m) {
            $list[] = $this->show($m);
        }
        return $list;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $posTraspaso = new PosTraspaso();
        $posTraspaso->fecha = $request->fecha;
        $posTraspaso->par_empresa_id = $request->empresa_id;
        $posTraspaso->par_sucursal_id = $request->sucursal_id;
        $posTraspaso->motivo = $request->motivo;
        // use pos_bodega_id for POS bodega foreign key
        $posTraspaso->pos_bodega_id = $request->pos_bodega_id ?? $request->bodega_id;
        $posTraspaso->documento_id = $request->documento_id;
        $posTraspaso->referencia = $request->referencia;
        $posTraspaso->t_neto = $request->t_neto;
        $posTraspaso->t_impuesto = $request->t_impuesto;
        $posTraspaso->total = $request->total;
        $posTraspaso->t_compra = $request->t_compra;
        $posTraspaso->tipo = $request->tipo;
        $posTraspaso->usuario_id = $request->usuario_id;
        $posTraspaso->save();
        $numero = PosTraspaso::all()->count();
        if (isset($request->carrito)) {
            if (!empty($request->carrito)) {
                foreach ($request->carrito as $m) {
                    $articulo = $m['articulo'];
                    $inventario = new PosInventario();
                    $inventario->articulo_id = $articulo['id'];
                    $inventario->tipo = $posTraspaso['tipo'];
                    $inventario->fecha = $posTraspaso['fecha'];
                    $inventario->compra = $m['precioc'];
                    $inventario->venta = $m['precio'];
                    $inventario->impuesto = $m['porcentaje'];
                    $inventario->total = $m['precio'] + $m['precio'] * $m['porcentaje'];
                    $inventario->v_impuesto = $m['precio'] * $m['porcentaje'];
                    // map to pos_bodega_id on inventario; fall back to legacy bodega_id
                    $inventario->pos_bodega_id = $articulo['pos_bodega_id'] ?? ($articulo['bodega_id'] ?? null);
                    $inventario->cantidad = $m['cantidad'];
                    $inventario->motivo = "posTraspaso #" . $numero;
                    $inventario->save();
                    $traspasoInventario = new TraspasoInventario();
                    $traspasoInventario->inventario_id = $inventario->id;
                    $traspasoInventario->venta_id = $posTraspaso->id;
                    $traspasoInventario->articulo_id = $articulo['id'];
                    $traspasoInventario->neto = $m['precio'];
                    $traspasoInventario->cantidad = $m['cantidad'];
                    $traspasoInventario->precioc = $m['precioc'];
                    $traspasoInventario->precio = $m['precio'] + $m['precio'] * $m['porcentaje'];
                    $traspasoInventario->impuesto = $m['porcentaje'];
                    $traspasoInventario->v_impuesto = $m['precio'] * $m['porcentaje'];
                    $traspasoInventario->tipo = $posTraspaso['tipo'];
                    $traspasoInventario->save();
                }
            }
        }
        return $posTraspaso;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PosTraspaso  $posTraspaso
     * @return \Illuminate\Http\Response
     */
    public function show(PosTraspaso $posTraspaso)
    {
        $posTraspaso->cliente = $posTraspaso->Cliente;
        $posTraspaso->metodo = $posTraspaso->Metodo;
        $posTraspaso->documento = $posTraspaso->Documento;
        $posTraspaso->traspaso_inventarios = $posTraspaso->TraspasoInventario()->with(['Inventario' => function ($i) {
            $i->with(['Articulo' => function ($a) {
                $a->with(['Marca', 'Categoria', 'Medida', 'Bodega']);
            }]);
        }])->get();
        return $posTraspaso;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PosTraspaso  $posTraspaso
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PosTraspaso $posTraspaso) {}

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PosTraspaso  $posTraspaso
     * @return \Illuminate\Http\Response
     */
    public function destroy(PosTraspaso $posTraspaso)
    {
        $posTraspaso->estado = 0;
        $posTraspaso->save();
    }
}
