<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Http\Request\LoginFormRequest;
use App\Models\UserEmpresa;
use App\Models\UserSucursal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Exports\UsersExport;
use Maatwebsite\Excel\Facades\Excel;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return User::with(['parSucursal', 'parEmpresa', 'Role'])->where('estado', 1)->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function export()
    {
        return Excel::download(new UsersExport, 'invoices.xlsx');
    }

    public function store(Request $request)
    {
        $user = new User();
        $user->nombre = $request->nombre;
        $user->s_nombre = $request->s_nombre;
        $user->a_paterno = $request->a_paterno;
        $user->a_materno = $request->a_materno;
        $user->email = $request->email;
        $user->username = $request->username;
        $user->password = Hash::make($request->password);
        $user->par_empresa_id = $request->par_empresa_id;
        $user->n_empresa = $request->n_empresa;
        $user->par_sucursal_id = $request->sucursal_id;
        $user->n_sucursal = $request->n_sucursal;
        $user->t_periodo_id = $request->t_periodo_id;
        $user->trabajador_id = $request->rem_ficha_id;
        $user->pos_bodega_id = $request->pos_bodega_id;
        $user->rol_id = $request->rol_id;
        $user->menu = $request->menu;
        $user->save();
        return $user;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        $user->empresa = $user->Empresa;
        $user->sucursal = $user->Sucursal;
        $user->tesoreria = $user->Tesoreria;
        $user->role = $user->role;
        return $user;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        $user->nombre = $request->nombre;
        $user->s_nombre = $request->s_nombre;
        $user->a_paterno = $request->a_paterno;
        $user->a_materno = $request->a_materno;
        $user->email = $request->email;
        $user->username = $request->username;
        $user->par_empresa_id = $request->par_empresa_id;
        $user->rol_id = $request->rol_id;
        $user->trabajador_id = $request->rem_ficha_id;
        $user->par_sucursal_id = $request->par_sucursal_id;
        $user->pos_bodega_id = $request->pos_bodega_id;
        $user->menu = $request->menu;
        if (isset($request->password)) {
            if (!empty($request->password)) {
                $user->password = Hash::make($request->password);
            }
        }

        $user->save();
        return $user;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user)
    {
        $user->estado = 0;
        $user->save();
    }

    public function loginConfirmar(LoginFormRequest $request)
    {
        if (!Auth::attempt(['username' => $request->username, 'password' => $request->password])) {
            return response()->json([
                'errors' => [
                    'login' => ['Los datos no son válidos']
                ]
            ], 401);
        }

        /** @var User $user */
        $user = Auth::user();

        // Cargar relaciones si las necesitas
        $user->load([
            'parSucursal',
            'parEmpresa',
            'Role',
        ]);

        // Crear un nuevo token para esa sesión (cliente)
        $token = $user->createToken('token-confirmar')->plainTextToken;

        return response()->json([
            'token' => $token,
            'user' => $user
        ]);
    }


    public function login(LoginFormRequest $request)
    {
        if (!Auth::attempt(['username' => $request->username, 'password' => $request->password])) {
            return response()->json([
                'errors' => [
                    'login' => ['Los datos no son válidos']
                ]
            ], 401);
        }

        /** @var User $user */
        $user = Auth::user();

        // Carga relaciones necesarias
        $user->load([
            'parSucursal',
            'parEmpresa',
            'Role',
            'ClienteUser.posCliente'
        ]);

        // Crea token personal
        $token = $user->createToken('token-login')->plainTextToken;

        return response()->json([
            'token' => $token,
            'user' => $user
        ]);
    }
}
