<?php

namespace App\Http\Controllers;

use App\Models\UserEmpresa;
use Illuminate\Http\Request;

class UserEmpresaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        return UserEmpresa::with(['user','parEmpresa'])->where('estado',1)->get();
    }
    public function Usuario(Request $request)
    {
        $usuario = $request->usuario;
        return UserEmpresa::with(['user','parEmpresa'])->where('estado',1)->where('user_id',$usuario)->get();
       

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
public function store(Request $request)
{
    // ✅ Si viene un array de empresas (lote)
    if ($request->has('empresas') && is_array($request->empresas)) {
        $insertados = [];

        foreach ($request->empresas as $empresa) {
            $userEmpresa = new UserEmpresa();
            $userEmpresa->user_id = $empresa['user_id'];
            $userEmpresa->par_empresa_id = $empresa['par_empresa_id'];
            $userEmpresa->save();
            $insertados[] = $userEmpresa;
        }

        return response()->json([
            'message' => 'Empresas asignadas correctamente',
            'data' => $insertados
        ]);
    }

    // ✅ Si viene un solo registro (modo antiguo)
    $userEmpresa = new UserEmpresa();
    $userEmpresa->user_id = $request->user_id;
    $userEmpresa->par_empresa_id = $request->par_empresa_id;
    $userEmpresa->save();

    return $userEmpresa;
}


    /**
     * Display the specified resource.
     *
     * @param  \App\Models\UserEmpresa  $usersEmpresa
     * @return \Illuminate\Http\Response
     */
    public function show(UserEmpresa $userEmpresa)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\UsersEmpresa  $usersEmpresa
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UserEmpresa $userEmpresa)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\UsersEmpresa  $usersEmpresa
     * @return \Illuminate\Http\Response
     */
    public function destroy(UserEmpresa $userEmpresa)
    {
        //
    }
}
