<?php

namespace App\Http\Controllers;

use App\Models\UserSucursal;
use Illuminate\Http\Request;

class UserSucursalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
    return UserSucursal::with(['user','parEmpresa','parSucursal'])->where('estado',1)->get();
    }
    public function Usuario(Request $request)
    {
        $usuario = $request->usuario;
    return UserSucursal::with(['user','parEmpresa','parSucursal'])->where('estado',1)->where('user_id',$usuario)->get();
       

    }
    public function Empresa(Request $request)
    {
        $usuario = $request->usuario;
        $empresa = $request->empresa;
    return UserSucursal::with(['user','parEmpresa','parSucursal'])->where('estado',1)->where('user_id',$usuario)->where('par_empresa_id','=',$empresa)->get();
       

    }
    
    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
{
    // ✅ Si viene un array de sucursales (lote)
    if ($request->has('sucursales') && is_array($request->sucursales)) {
        $insertados = [];

            foreach ($request->sucursales as $sucursal) {
            $userSucursal = new UserSucursal();
            $userSucursal->user_id = $sucursal['user_id'];
            $userSucursal->par_empresa_id = $sucursal['par_empresa_id'];
            $userSucursal->par_sucursal_id = $sucursal['par_sucursal_id'];
            $userSucursal->save();
            $insertados[] = $userSucursal;
        }

        return response()->json([
            'message' => 'Sucursales asignadas correctamente',
            'data' => $insertados
        ]);
    }

    // ✅ Si viene un solo registro (modo antiguo)
    $userSucursal = new UserSucursal();
    $userSucursal->user_id = $request->user_id;
    $userSucursal->par_empresa_id = $request->par_empresa_id;
    $userSucursal->par_sucursal_id = $request->par_sucursal_id;
    $userSucursal->save();

    return $userSucursal;
}

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\UserSucursal  $userSucursal
     * @return \Illuminate\Http\Response
     */
    public function show(UserSucursal $userSucursal)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\UserSucursal  $userSucursal
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UserSucursal $userSucursal)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\UserSucursal  $userSucursal
     * @return \Illuminate\Http\Response
     */
    public function destroy(UserSucursal $userSucursal)
    {
        
    }
}
