<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;

class VerifyCsrfToken extends Middleware
{
    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array<int, string>
     */
    protected $except = [
        // by default no URIs excluded here; we may add api/* dynamically below
    ];

    public function __construct(\Illuminate\Contracts\Encryption\Encrypter $encrypter = null)
    {
        parent::__construct($encrypter);

        // Si ROUTES_PROTECTED está desactivado, excluimos todas las rutas API
        // de la verificación CSRF para evitar errores cuando no usamos
        // auth:sanctum stateful.
        if (!config('routes.protected')) {
            $this->except[] = 'api/*';
        }
    }
}
