<?php

namespace App\Libraries\LibreDTE;

use App\Libraries\LibreDTE\FirmaElectronica;
use Exception;
use SoapClient;

class EstadoDte
{
    /**
     * Consulta el estado del DTE en el SII por Track ID
     */
    public function consultar($rutEmisor, $rutEnvia, $trackId)
    {
        $xml = <<<XML
<getEstDteRequest xmlns="http://www.sii.cl/SiiDte">
    <RutConsultante>{$rutEnvia}</RutConsultante>
    <RutCompania>{$rutEmisor}</RutCompania>
    <TipoConsulta>1</TipoConsulta>
    <TrackId>{$trackId}</TrackId>
</getEstDteRequest>
XML;

        // Firmar la consulta
        $firma = new FirmaElectronica(storage_path('app/' . env('CERTIFICADO_PFX')), env('CERTIFICADO_PASSWORD'));
        $xmlFirmado = $firma->firmarXML($xml, 'getEstDteRequest');

        // Token
        $token = $firma->obtenerToken();

        // Crear contexto con header
        $context = stream_context_create([
            'http' => [
                'header' => "Content-type: text/xml;charset=ISO-8859-1\r\nAuthorization: TOKEN $token"
            ]
        ]);

        // Enviar al SII
        $client = new SoapClient(null, [
            'location' => env('SII_ESTADO_URL'), // debe estar en tu .env
            'uri' => "http://tempuri.org/",
            'trace' => 1,
            'stream_context' => $context,
        ]);

        $response = $client->__doRequest($xmlFirmado, env('SII_ESTADO_URL'), '', 1);

        $xmlResp = simplexml_load_string($response);

        if (!$xmlResp || !isset($xmlResp->ESTADO)) {
            throw new Exception("Respuesta inválida del SII:\n" . $response);
        }

        return (string) $xmlResp->ESTADO;
    }
}
