<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;

class Caf extends Model
{
    protected $table = 'cafs';

    protected $fillable = [
        'empresa_id',
        'tipo_dte',
        'folio_desde',
        'folio_hasta',
        'caf_xml',
        'activo',
        'usado_hasta',
    ];

    protected $casts = [
        'empresa_id'   => 'integer',
        'tipo_dte'     => 'integer',
        'folio_desde'  => 'integer',
        'folio_hasta'  => 'integer',
        'activo'       => 'boolean',
    ];

    public function getXmlCAF(): \DOMElement
{
    $doc = new \DOMDocument();
    $doc->loadXML($this->caf_xml); // Asume que el XML del CAF está en este campo
    return $doc->documentElement;
}
}
    