<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Certificado extends Model
{
    use HasFactory;

    protected $table = 'certificados';

    protected $fillable = [
        'par_representante_id',
        'ruta_archivo',
        'clave',
        'fecha_vencimiento'
    ];

    // Relación con la empresa
    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    // Relación con el representante (puede ser User o un modelo Representante si tienes uno)
    public function representante()
    {
        // Si el representante es un ParRepresentante, enlazamos por par_representante_id
        return $this->belongsTo(\App\Models\Parametros\ParRepresentante::class, 'par_representante_id');
    }
}
