<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;

class ConAAutDetalle extends Model
{
    protected $table = 'con_a_aut_detalles';

    protected $primaryKey = 'id';

    protected $fillable = [
        'con_a_automatico_id',
        'con_sub_cuenta_id',
        'debe_haber',
        'estado',
    ];

    // Relación con el asiento automático
    public function automatico()
    {
        return $this->belongsTo(ConAAutomatico::class, 'con_a_automatico_id');
    }

    // Relación con la subcuenta contable
    public function subCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
}
