<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;

class ConAAutomatico extends Model
{
    protected $table = 'con_a_automaticos';

    protected $primaryKey = 'id';

    protected $fillable = [
        'nombre',
        'con_t_voucher_id',
        'ajuste',
        't_ajuste',
        'par_empresa_id',
        'unico',
        'estado',
    ];

    // Relación con Empresa
    public function parEmpresa()
    {
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class, 'par_empresa_id');
    }

    // Relación con Tipo de Voucher
    public function conTVoucher()
    {
        return $this->belongsTo(\App\Models\Contabilidad\ConTVoucher::class, 'con_t_voucher_id');
    }
}
