<?php

namespace App\Models\Contabilidad;

use App\Models\Contabilidad\ConTipoCuenta;
use Illuminate\Database\Eloquent\Model;

class ConCategoriaCuenta extends Model
{
    protected $table = 'con_categoria_cuentas';

    protected $fillable = [
        'tipo_cuenta_id',
        'codigo',
        'nombre',
        'estado'
    ];

    public function tipoCuenta()
    {
        return $this->belongsTo(ConTipoCuenta::class, 'tipo_cuenta_id');
    }

    public function cuentas()
{
    return $this->hasMany(ConCuenta::class, 'con_categoria_cuenta_id');
}
public function conCuentaMadre()
{
    return $this->hasMany(ConCuentaMadre::class, 'con_categoria_cuenta_id');
}



} 
