<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ConClienteCuenta extends Model
{
    use HasFactory;

    protected $fillable = [
        'pos_cliente_id',
        'con_sub_cuenta_id',
        'par_empresa_id',
        'estado',
    ];

    public function posCliente()
    {
        return $this->belongsTo(\App\Models\Pos\PosCliente::class, 'pos_cliente_id');
    }

    public function conSubCuenta()
    {
        // Ajusta el namespace si ConSubCuenta no está en App\Models\Contabilidad
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }

    public function parEmpresa()
    {
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class, 'par_empresa_id');
    }
}

