<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConCuentaMadre extends Model
{
    use HasFactory;

    // Tabla relacionada con el modelo
    protected $table = 'con_cuenta_madres';

    // Campos que pueden ser llenados de manera masiva
    protected $fillable = [
        'codigo',
        'nombre',
        'con_categoria_cuenta_id',
        'estado'
    ];

    // Relación con la tabla 'tipo_cuentas'
    public function ConCategoriaCuenta()
    {
        return $this->belongsTo(ConCategoriaCuenta::class, 'con_categoria_cuenta_id');
    }

    public function cuentas()
    {
        return $this->hasMany(ConCuenta::class, 'con_cuenta_madre_id');
    }
} 
