<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConCuentaSiiHVenta extends Model
{
    use HasFactory;
     protected $table = 'con_cuenta_sii_h_ventas';

    protected $fillable = [
        'nombre',
        'empresa_id',
        'con_sub_cuenta_id',
        'estado',
    ];

    protected $casts = [
        'empresa_id' => 'integer',
        'con_sub_cuenta_id' => 'integer',
        'estado' => 'boolean',
    ];

    // Relaciones
    public function parEmpresa()
    {
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }
    

    public function ConSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
}
