<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConCuentasSiiCompra extends Model
{
    use HasFactory;

    protected $table = 'con_cuentas_sii_compras'; // Nombre de la tabla

    protected $fillable = [
        'nombre',
        'empresa_id',
        'con_sub_cuenta_id',
        'estado',
        'created_at',
        'updated_at',
    ];

    // Si no usas timestamps automáticos (created_at, updated_at)
    public $timestamps = false;

    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
}
 