<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ConImpuesto extends Model
{
    use HasFactory;

    protected $fillable = [
        'con_sub_cuenta_id',
        'codigo',
        'nombre',
        'grupo',
        'modo',
        'aplica_a',
        'base_calculo',
        'prioridad',
        'unidad_base',
        'factor_unidad',
        'estado',
    ];
    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }

    public function conImpuestoCuenta()
{
    return $this->hasMany(ConImpuestoCuenta::class, 'con_impuesto_id');
}


}