<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConImpuestoCuenta extends Model
{
    use HasFactory;

    protected $fillable = [
        'con_impuesto_id',
        'empresa_id',
        'con_sub_cuenta_id',
    ];

    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
    
    public function conImpuesto()
    {
        return $this->belongsTo(ConImpuesto::class, 'con_impuesto_id');
    }

     public function articulos()
    {
        return $this->hasMany(\App\Models\Pos\PosArticuloImpuesto::class, 'con_impuesto_id');
    }
    
}

