<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConLibroDiario extends Model
{
    use HasFactory;

    // Especificamos la tabla si no sigue el nombre estándar
    protected $table = 'con_libro_diarios';

    // Definimos los campos que pueden ser asignados masivamente
    protected $fillable = [
        'con_voucher_id',
        'sub_cuenta_id',
        'monto',
        'estado',
    ];

    // Especificamos si la tabla tiene las columnas 'created_at' y 'updated_at'
    public $timestamps = true;

    // Relación con el modelo 'Voucher' (suponiendo que exista una relación con la tabla 'con_vouchers')

    // Relación con el modelo 'SubCuenta' (suponiendo que exista una relación con la tabla 'con_sub_cuentas')
    public function subCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
    public function voucher()
    {
        return $this->belongsTo(ConVoucher::class, 'con_voucher_id');
    }
    
}
