<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ConLibroFoliado extends Model
{
    use HasFactory;

    protected $table = 'con_libro_foliados';

    protected $fillable = [
        'tipo_libro',
        'empresa_id',
        'p_desde',
        'p_hasta',
        'par_anio_id',
        'c_desde',
        'c_hasta',
        'estado',
        'por_periodo', // 1 = por mes, 0 = por año
    ];

    public function parEmpresas()
    {
    return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }
    public function parAnios()
    {
    return $this->belongsTo(\App\Models\Parametros\ParAnio::class, 'par_anio_id');
    }

    public function parPeriodos()
    {
    return $this->belongsTo(\App\Models\Parametros\ParPeriodo::class, 'par_periodo_id');
    }
}
