<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;

class ConParFormulario extends Model
{
    protected $table = 'con_par_formularios';

    protected $fillable = [
        'con_formulario_id',
        'codigo',
        'd_corta',
        'd_formulario',
        'estado',
    ];

    public function formulario()
    {
        return $this->belongsTo(ConFormulario::class, 'con_formulario_id');
    }

    public function detalles()
    {
        return $this->hasMany(ConFormularioDetalle::class, 'con_par_formulario_id');
    }
}
