<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConPreLibCompra extends Model
{
    use HasFactory;
    protected $fillable = [
        'con_sii_libro_id',
        'empresa_id',
    't_periodo_id',
    'par_anio_id',
        'con_sub_cuenta_id',
        'par_c_costo_id',
        'con_voucher_p_id',
        'debe',
        'haber'
        // Aquí puedes agregar otros campos que deseas permitir para la asignación masiva
    ];

    public function ConSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }

    public function parEmpresa()
    {
    return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class, 'par_empresa_id');
    }

    public function conSiiCompra()
    {
        return $this->belongsTo(ConSiiCompra::class, 'con_sii_libro_id');
    }
}
