<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConPreLibHCompra extends Model
{
    use HasFactory;

    protected $table = 'con_pre_lib_h_compras';

    protected $fillable = [
        'con_sii_h_compra_id',
        'h_venta_id',
        'con_voucher_id',
        'con_sub_cuenta_id',
        'debe',
        'haber',
    't_periodo_id',
    'par_anio_id',
        'centralizado',
        'estado',
        'empresa_id',
        'par_c_costo_id',
        'con_voucher_p_id',
    ];

    protected $casts = [
        'debe' => 'decimal:2',
        'haber' => 'decimal:2',
        'centralizado' => 'integer',
        'estado' => 'integer',
    ];

    // Relaciones sugeridas
   public function ConSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }

    public function Empresa()
    {
    return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class, 'empresa_id');
        
    }

    public function conSiiHCompra()
    {
        return $this->belongsTo(ConSiiHCompra::class, 'con_sii_h_compra_id');
    }
}
