<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConPreLibVenta extends Model
{
    use HasFactory;

     protected $fillable = [
        'registro_id',
        'empresa_id',
    'par_periodo_id',
        'ven_cliente_id',
        'con_sub_cuenta_id',
        'con_voucher_p_id',
        'tipo',
        'monto1',
        'monto2',
        'editable',
        'cod_doc',
        'con_sii_libro_id', // ✅ AGREGA ESTE CAMPO
        'debe',
    'haber',
    'par_anio_id', // 👈 AGREGAR ESTO
    ];

    public function ConSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }

    public function parEmpresa()
    {
    return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class, 'empresa_id');
    }

    public function conSiiVenta()
    {
        return $this->belongsTo(ConSiiVenta::class, 'con_sii_libro_id');
    }
}
