<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConProveedorCuenta extends Model
{
    use HasFactory;

    protected $table = 'con_proveedor_cuentas';

    protected $fillable = [
        'proveedor_id',
        'con_sub_cuenta_id',
        'par_empresa_id',
        'estado',
    ];

    // Relaciones

    public function posProveedor()
    {
        return $this->belongsTo(\App\Models\Pos\PosProveedor::class);
    }

    public function parEmpresa()
    {
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }

    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class);
    }
}
