<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ConRendicion extends Model
{
    use HasFactory;

    protected $table = 'con_rendiciones';

    protected $fillable = [
        'fecha',
        'rut_rinde',
        'n_rinde',
        'monto_total',
        'observacion',
        'e_pago',
    'par_periodo_id',
        'empresa_id',
        'estado',
        'centralizado',
        'con_voucher_id',
       
    ];

    // Relaciones
    public function detalles()
    {
        return $this->hasMany(ConRendicionDetalle::class, 'con_rendicione_id');
    }

    public function parPeriodo()
    {
    return $this->belongsTo(\App\Models\Parametros\ParPeriodo::class, 'par_periodo_id');
    }

    public function parEmpresa()
    {
    return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }
}
