<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ConRendicionDetalle extends Model
{
    use HasFactory;

    protected $table = 'con_rendicion_detalles';

    protected $fillable = [
        'con_rendicione_id',
        'doc_tributario_id',
        'con_sii_compra_id',
        'folio',
        'detalle',
        'monto',
        'con_sub_cuenta_id',
        'centralizado',
        'estado',
         'razon_social',
    ];

    // Relaciones
    public function rendicion()
    {
        return $this->belongsTo(ConRendicion::class, 'con_rendicione_id');
    }

    public function docTributario()
    {
    return $this->belongsTo(\App\Models\Contabilidad\ConDocTributario::class);
    }

    public function compra()
    {
    return $this->belongsTo(ConSiiCompra::class, 'con_sii_compra_id');
    }

    public function subCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
}
