<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConSiiCompra extends Model
{
    use HasFactory;

    protected $table = 'con_sii_compras';

    protected $fillable = [
        'rut_empresa',
        'par_empresa_id',
        'periodo',
        'par_periodo_id',
        'Nro',
        'Tipo_Doc',
        'Tipo_Compra',
        'RUT_Proveedor',
        'pos_proveedor_id',
        'Razon_Social',
        'Folio',
        'Fecha_Docto',
        'Fecha_Recepcion',
        'Fecha_Acuse',
        'Monto_Exento',
        'Monto_Neto',
        'Monto_IVA_Recuperable',
        'Monto_IVA_Uso_Comun',
        'Monto_IVA_No_Recuperable',
        'Codigo_IVA_No_Recuperable',
        'Monto_Total',
        'Monto_Neto_Activo_Fijo',
        'IVA_uso_Comun',
        'Impto_Sin_Derecho_Credito',
        'IVA_No_Retenido',
        'Tabacos_Puros',
        'Tabacos_Cigarrillos',
        'Tabacos_Elaborados',
        'NCE_o_NDE',
        'Codigo_Otro_Impuesto',
        'Valor_Otro_Impuesto',
        'Tasa_Otro_Impuesto',
        'con_cuenta_proveedor_id',
    ];

    public $timestamps = false;



    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }


     // 👇 Este es el campo computado que se adjunta automáticamente
    protected $appends = ['con_sub_cuenta_id'];

    // 🔁 Devuelve el con_sub_cuenta_id calculado dinámicamente
    public function getConSubCuentaIdAttribute()
    {
        // 1️⃣ Buscar en con_proveedor_cuentas
        $cuentaProveedor = ConProveedorCuenta::where('par_empresa_id', $this->par_empresa_id)
            ->where('pos_proveedor_id', $this->pos_proveedor_id)
            ->first();

        if ($cuentaProveedor && $cuentaProveedor->con_sub_cuenta_id) {
            return $cuentaProveedor->con_sub_cuenta_id;
        }

        // 2️⃣ Buscar en con_cuenta_generals si no encontró antes
        $cuentaGeneral = ConCuentaGeneral::where('par_empresa_id', $this->par_empresa_id)
            ->where('nombre', 'Por Defecto')
            ->first();

        if ($cuentaGeneral && $cuentaGeneral->con_sub_cuenta_id) {
            return $cuentaGeneral->con_sub_cuenta_id;
        }

        return null;
    }

    // (Opcional) relaciones que ya tengas
    public function cuentaProveedor()
    {
        return $this->belongsTo(ConProveedorCuenta::class, 'con_cuenta_proveedor_id');
    }
     public function Proveedor()
    {
    return $this->belongsTo(\App\Models\Pos\PosProveedor::class, 'pos_proveedor_id');
    }
}
