<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConSiiHCompra extends Model
{
    use HasFactory;

    protected $table = 'con_sii_h_compras';

    protected $fillable = [
        'numero',
        'fecha',
        'estado',
        'fecha_anulacion',
        'rut',
        'nombre_razon_social',
        'soc_prof',
        'brutos',
        'retenido',
        'pagado',
        'par_empresa_id',
        'par_periodo_id',
        'periodo',
        'estado_doc',
        'tipo_doc',
        'pos_proveedor_id',
        'con_cuenta_proveedor_id',
    ];

    protected $casts = [
        'fecha' => 'date',
        'fecha_anulacion' => 'date',
        'soc_prof' => 'boolean',
        'brutos' => 'decimal:2',
        'retenido' => 'decimal:2',
        'pagado' => 'decimal:2',
    ];

    // 👇 Se agrega el campo computado automáticamente
    protected $appends = ['con_sub_cuenta_id'];

    // 🔁 Devuelve el con_sub_cuenta_id calculado dinámicamente
    public function getConSubCuentaIdAttribute()
    {
        // Buscar cuenta personalizada por proveedor
        $cuentaProveedor = ConProveedorCuenta::where('par_empresa_id', $this->par_empresa_id)
            ->where('pos_proveedor_id', $this->pos_proveedor_id)
            ->first();

        if ($cuentaProveedor && $cuentaProveedor->con_sub_cuenta_id) {
            return $cuentaProveedor->con_sub_cuenta_id;
        }

        // Si no existe, usar cuenta por defecto
        $cuentaGeneral = ConCuentaSiiHCompra::where('par_empresa_id', $this->par_empresa_id)
            ->where('nombre', 'brutos')
            ->first();

        return $cuentaGeneral->con_sub_cuenta_id ?? null;
    }

    // ✅ Relaciones replicadas
    public function parEmpresa()
    {
        return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }

    public function proveedor()
    {
        return $this->belongsTo(\App\Models\Pos\PosProveedor::class, 'pos_proveedor_id');
    }

    public function parPeriodo()
    {
        return $this->belongsTo(\App\Models\Parametros\ParPeriodo::class, 'par_periodo_id');
    }

    public function cuentaProveedor()
    {
        return $this->belongsTo(ConProveedorCuenta::class, 'con_cuenta_proveedor_id');
    }

    // (Opcional) Relación si se crea columna real `con_sub_cuenta_id` en la tabla
    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }
}
