<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;

class ConSiiHVenta extends Model
{
    protected $table = 'con_sii_h_ventas';

    protected $fillable = [
        'numero',
        'fecha',
        'estado',
        'fecha_anulacion',
        'rut',
        'nombre_razon_social',
        'soc_prof',
        'brutos',
        'retenido',
        'pagado',
        'par_empresa_id',
    'par_periodo_id',
        'periodo',
        'estado_doc',
        'tipo_doc',
        'pos_cliente_id',
        'con_cuenta_cliente_id',
    ];

    protected $casts = [
        'fecha' => 'date',
        'fecha_anulacion' => 'date',
        'soc_prof' => 'boolean',
        'brutos' => 'decimal:2',
        'retenido' => 'decimal:2',
        'pagado' => 'decimal:2',
    ];


    /**
     * Relaciones
     */
    public function ConSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }


     // 👇 Este es el campo computado que se adjunta automáticamente
    protected $appends = ['con_sub_cuenta_id'];

    // 🔁 Devuelve el con_sub_cuenta_id calculado dinámicamente
    public function getConSubCuentaIdAttribute()
{
    if (!$this->par_empresa_id || !$this->pos_cliente_id) {
        return null;
    }

    $cuentaCliente = ConClienteCuenta::where('par_empresa_id', $this->par_empresa_id)
        ->where('pos_cliente_id', $this->pos_cliente_id)
        ->first();

    if ($cuentaCliente && $cuentaCliente->con_sub_cuenta_id) {
        return $cuentaCliente->con_sub_cuenta_id;
    }

    $cuentaGeneral = ConCuentaSiiHVenta::where('par_empresa_id', $this->par_empresa_id)
        ->where('nombre', 'brutos')
        ->first();

    return $cuentaGeneral->con_sub_cuenta_id ?? null;
}

    // (Opcional) relaciones que ya tengas
    public function cuentaCliente()
    {
        return $this->belongsTo(ConClienteCuenta::class, 'con_cuenta_cliente_id');
    }
     public function PosCliente()
    {
    return $this->belongsTo(\App\Models\Pos\PosCliente::class, 'pos_cliente_id');
    }
}
