<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ConSiiPendiente extends Model
{
    use HasFactory;

    protected $table = 'con_sii_pendientes';

    protected $fillable = [
        'tipo_doc',
        'tipo_compra',
        'rut_proveedor',
        'razon_social',
        'pos_proveedor_id',
        'folio',
        'fecha_docto',
        'fecha_recepcion',
        'monto_exento',
        'monto_neto',
        'monto_iva_recuperable',
        'monto_iva_no_recuperable',
        'codigo_iva_no_rec',
        'monto_total',
        'par_empresa_id',
        'par_periodo_id',
        'estado',
    ];

    protected $casts = [
        'fecha_docto' => 'date',
        'fecha_recepcion' => 'date',
        'monto_exento' => 'decimal:2',
        'monto_neto' => 'decimal:2',
        'estado' => 'integer',
    ];

    // Relaciones (opcional, si tienes modelos Empresa y Periodo)
    public function parEmpresa()
    {
    return $this->belongsTo(\App\Models\Parametros\ParEmpresa::class);
    }

    public function parPeriodo()
    {
    return $this->belongsTo(\App\Models\Parametros\ParPeriodo::class, 'par_periodo_id');
    }
     public function Proveedor()
    {
        return $this->belongsTo(\App\Models\Pos\PosProveedor::class);
    }
}

