<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;
use App\Models\Contabilidad\ConClienteCuenta;
use App\Models\Contabilidad\ConCuentaSiiVenta;
use App\Models\Contabilidad\ConSubCuenta;
use App\Models\Pos\PosCliente;

class ConSiiVenta extends Model
{
    protected $table = 'con_sii_ventas';

    public $timestamps = false;

    protected $fillable = [
        'rut_empresa',
        'periodo',
        'par_periodo_id',
        'par_empresa_id',
        'pos_cliente_id',
        'Nro',
        'Tipo_Doc',
        'Tipo_Venta',
        'Rut_cliente',
        'Razon_Social',
        'Folio',
        'Fecha_Docto',
        'Fecha_Recepcion',
        'Fecha_Acuse_Recibo',
        'Fecha_Reclamo',
        'Monto_Exento',
        'Monto_Neto',
        'Monto_IVA',
        'Monto_total',
        'IVA_Retenido_Total',
        'IVA_Retenido_Parcial',
        'IVA_no_retenido',
        'IVA_propio',
        'IVA_Terceros',
        'RUT_Emisor_Liquid_Factura',
        'Neto_Comision_Liquid_Factura',
        'Exento_Comision_Liquid_Factura',
        'IVA_Comision_Liquid_Factura',
        'IVA_fuera_de_plazo',
        'Tipo_Docto_Referencia',
        'Folio_Docto_Referencia',
        'Num_Ident_Receptor_Extranjero',
        'Nacionalidad_Receptor_Extranjero',
        'Credito_empresa_constructora',
        'Impto_Zona_Franca',
        'Garantia_Dep_Envases',
        'Indicador_Venta_sin_Costo',
        'Indicador_Servicio_Periodico',
        'Monto_No_facturable',
        'Total_Monto_Periodo',
        'Venta_Pasajes_Transporte_Nacional',
        'Venta_Pasajes_Transporte_Internacional',
        'Numero_Interno',
        'Codigo_Sucursal',
        'NCE_o_NDE_sobre_Fact_de_Compra',
        'Codigo_Otro_Imp',
        'Valor_Otro_Imp',
        'Tasa_Otro_Imp',
        'con_cuenta_cliente_id',
        'con_sub_cuenta_id',
    ];

  
    public function conSubCuenta()
    {
        return $this->belongsTo(ConSubCuenta::class, 'con_sub_cuenta_id');
    }


     // 👇 Este es el campo computado que se adjunta automáticamente
    protected $appends = ['con_sub_cuenta_id'];

    // 🔁 Devuelve el con_sub_cuenta_id calculado dinámicamente
    public function getConSubCuentaIdAttribute()
{
    if (!$this->par_empresa_id || !$this->pos_cliente_id) {
        return null;
    }

    $cuentaCliente = ConClienteCuenta::where('par_empresa_id', $this->par_empresa_id)
        ->where('pos_cliente_id', $this->pos_cliente_id)
        ->first();

    if ($cuentaCliente && $cuentaCliente->con_sub_cuenta_id) {
        return $cuentaCliente->con_sub_cuenta_id;
    }

    $cuentaGeneral = ConCuentaSiiVenta::where('par_empresa_id', $this->par_empresa_id)
        ->where('nombre', 'Por Defecto')
        ->first();

    return $cuentaGeneral->con_sub_cuenta_id ?? null;
}

    // (Opcional) relaciones que ya tengas
    public function cuentaCliente()
    {
        return $this->belongsTo(ConClienteCuenta::class, 'con_cuenta_cliente_id');
    }
     public function posCliente()
    {
        return $this->belongsTo(\App\Models\Pos\PosCliente::class, 'pos_cliente_id');
    }
}
