<?php

namespace App\Models\Contabilidad;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConSubCuenta extends Model
{
    use HasFactory;

    protected $table = 'con_sub_cuentas';

    protected $fillable = [
        'cuenta_id',
        'nombre',
        'codigo',
        'especial',
        'estado',
        'usuario_id',
    ];

    // Relaciones si las quieres agregar después:
    public function cuenta()
    {
        return $this->belongsTo(ConCuenta::class, 'cuenta_id');
    }



    public function usuario()
    {
        return $this->belongsTo(\App\Models\User::class, 'usuario_id');
    }
    public function ConCuenta(){
        return $this->belongsTo(ConCuenta::class);
    }
    public function ConPreLibCompras(){
        return $this->belongsTo(ConCuenta::class);
    }

    public function conCuentaMadre()
{
    return $this->belongsTo(ConCuentaMadre::class, 'con_cuenta_madre_id');
}

public function conImpuestoCuenta()
{
    return $this->belongsTo(ConImpuestoCuenta::class, 'con_sub_cuenta_id');
}

}
 