<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dte extends Model
{
    use HasFactory;

    protected $table = 'dtes';

    protected $fillable = [
        'venta_id',
        'empresa_id',
        'tipo_dte',
        'cliente_id',
        'fecha_emision',
        'folio',
        'estado',
        'ruta_xml',
        'xml', // 👈 ASEGÚRATE que esté aquí
        'fecha' // 👈 Que este esté incluido aqu
    ];

    // Relaciones si quieres usarlas después:
    public function venta()
    {
        return $this->belongsTo(Venta::class, 'venta_id');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresa_id');
    }
}
