<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DteDetalle extends Model
{
    protected $table = 'dte_detalles';

    protected $fillable = [
        'dte_id',
        'producto_id',
        'descripcion',
        'cantidad',
        'precio_unitario',
        'total'
    ];

    // RELACIÓN: cada detalle pertenece a un DTE
    public function dte()
    {
        return $this->belongsTo(Dte::class, 'dte_id');
    }

    // RELACIÓN: si quieres, cada detalle puede tener un producto (opcional)
    public function producto()
    {
        return $this->belongsTo(Articulo::class, 'producto_id');
    }
}
