<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Trabajador;
use App\Models\ParAnio;
use App\Models\ParMese;

class Liquidacion extends Model
{
    use HasFactory;
     public function LiquidacionDoctos(){
        return $this->hasMany(LiquidacionDocto::class)->with(['documento'])->where('estado',1)->orderBy('id','desc');
    }
    public function Trabajador(){
        return $this->belongsTo(Trabajador::class);
    }
    public function Ano(){
    return $this->belongsTo(ParAnio::class, 'par_anio_id');
    } 
    public function Mese(){
        return $this->belongsTo(ParMese::class, 'par_mese_id');
    }
}
