<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MantencionDetalle extends Model
{
    use HasFactory;
    public function Maquinaria(){
        return $this->belongsTo(Maquinaria::class);
    }
    public function marca()
    {
        return $this->belongsTo(Marca::class, 'marca_id'); // Usa el campo correcto
    }
    public function Mantencione(){
        return $this->belongsTo(\App\Models\PosMantencione::class, 'pos_mantencione_id');  // Referencia al modelo PosMantencione
    }
    
    protected $fillable = [
        'f_entrada',
        'f_salida',
        'pos_m_despacho_id',
        'estado',
        // otros campos que tengas en la tabla
    ];

    
    public function mantencione_detalles()
    {
        return $this->hasMany(MantencionDetalle::class, 'mantencione_id');
    }
    public function m_d_mantenciones()
    {
    return $this->hasMany(MDMantencione::class, 'pos_mantencion_detalle_id');  // Ajusta el nombre de la columna si es diferente
    }

    public function mdMantenciones()
{
    return $this->hasMany(MDMantencione::class, 'pos_mantencion_detalle_id');
}
}
