<?php

namespace App\Models\Parametros;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParActFijo extends Model
{
    use HasFactory;
      protected $table = 'par_act_fijos';
    protected $primaryKey = 'par_act_fijo_id';
    protected $fillable = [
        'codigo', 'nombre', 'descripcion', 'fecha_adquisicion', 'valor_adquisicion', 'valor_residual',
        'vida_util_anios', 'metodo_depreciacion', 'par_c_costo_id', 'par_proyecto_id', 'ubicacion',
        'n_responsable', 'rut_responsable', 'proveedor_id', 'estado', 'fecha_baja', 'motivo_baja',
        'observaciones', 'empresa_id'
    ];

    public function centroCosto()
    {
        return $this->belongsTo(ParCCosto::class, 'par_c_costo_id');
    }

    public function proyecto()
    {
        return $this->belongsTo(ParProyecto::class, 'par_proyecto_id');
    }

    public function proveedor()
    {
        return $this->belongsTo(\App\Models\Proveedor::class);
    }

    public function parEmpresa()
    {
        return $this->belongsTo(ParEmpresa::class);
    }
}
